#ifndef _ENTRY_CPP
#define _ENTRY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../Headers/NSWFL.H"
#include "../Headers/Entry.H"
#include "../Headers/Package.H"
#include "../Headers/Init.H"
#include "../Headers/CRC32.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/OpenPassDlg.H"
#include "../Dialogs/NewPassDlg.H"
#include "../Dialogs/ReadingDlg.H"
#include "../Dialogs/ExtractDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HINSTANCE ghAppInstance = NULL;

char gsAppCopyRight[64];
char gsFileVersion[32];
char gsTitleCaption[64];
char gsWorkingInput[256];
char gsWorkingOutput[256];

DWORD gdwCurrentJobType = 0;

short giCompressLevel = 0;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR CmdLine, int CmdShow)
{
	ghAppInstance = hInstance;

	HANDLE xMutex = NULL;

    if(!InitializeApp())
    {
        return 1;
    }

	if( (xMutex = OpenMutex(SYNCHRONIZE, FALSE, gsTitleCaption)) )
	{
		MessageBox(NULL, "Only one instance can run at a time!" ,gsTitleCaption, MB_ICONASTERISK + MB_SYSTEMMODAL);
		ReleaseMutex(xMutex);
		CloseHandle(xMutex);
		return 0;
	}
	else xMutex = CreateMutex(0, 0, gsTitleCaption);

    InitializeCRCTable();

    //DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_EXTRACT), NULL, ExtractDialog);

    if(strlen(CmdLine) > 0)
    {
        strcpy(gsWorkingInput, CmdLine);
        strcpy(gsWorkingOutput, "C:\\i386Beta.PCE");

        char Ext[255];
        _splitpath(CmdLine, NULL, NULL, NULL, Ext);

        if(strcmpi(Ext, ".pce") == 0)
        {
            // View an existing archive
            gdwCurrentJobType = JOB_TYPE_READING;
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_OPENPASS), NULL, OpenPassDialog) != 1)
            {
                return 0;
            }
            Worker_Thread_Handle = CreateThread(NULL, 0, ViewExisting_Worker_Thread, (LPVOID) CmdLine, CREATE_SUSPENDED, &Worker_Thread_ID);
            DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
        }
        else if(IsDirectory(CmdLine)){
            gdwCurrentJobType = JOB_TYPE_PACKING;
            // Create a new archive from the directorys contents
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_NEWPASS), NULL, NewPassDialog) != 1)
            {
                return 0;
            }
            Worker_Thread_Handle = CreateThread(NULL, 0, CreateNewDirArchive_Worker_Thread, (LPVOID) CmdLine, CREATE_SUSPENDED, &Worker_Thread_ID);
            DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
        }
        else{
            // Create a new archive containing a single file
        }

    }
    else{
        // Create new archive
        DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
    }

    DWORD ExitCode;
    while(GetExitCodeThread(Worker_Thread_Handle, &ExitCode))
    {
        if(ExitCode != STILL_ACTIVE)
        {
            break;
        }
        else Sleep(100);
    }

    if(!UninitializeApp())
    {
        return 1;
    }

	ReleaseMutex(xMutex);
	CloseHandle(xMutex);

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

